//=============================================================================
// Shop Keeper Gun, allows you to manage the shop!
//=============================================================================
class ShopKeeperGun extends DeusExWeapon;

var bool bNegMod;
var int ModAmount;
var bool XMode;
var int PayModAmount;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 0);
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

function CycleAmmo()
{

 if (!XMode)
 {
 ModAmount += 5;
 
 if (ModAmount > 100)
  ModAmount = 5;
 
 Pawn(Owner).ClientMessage("|p4You are now modifying costs by the amount "$ModAmount$"!");
 }

 if (XMode)
 {
 PayModAmount += 1;
 
 if (PayModAmount > 5)
  PayModAmount = 1;
 
 Pawn(Owner).ClientMessage("|p4You are now modifying employee's pay by the amount "$PayModAmount$"!");
 }
}

function ScopeToggle()
{
if (!bNegMod)
{
 bNegMod = True;
 Pawn(Owner).ClientMessage("|p2You are now modifying costs with a negative amount!");
 return; 
}
else if (bNegMod)
{
 bNegMod = False;
 Pawn(Owner).ClientMessage("|p3You are now modifying costs with a positive amount!");
 return; 
}
}

function LaserToggle()
{
if (!XMode)
{
 XMode= True;
 Pawn(Owner).ClientMessage("|p2You are now modifying employee's pay!");
 return; 
}

else if (XMode)
{
 XMode = False;
 Pawn(Owner).ClientMessage("|p3You are now modifying button prices!");
 return; 
}
}


function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
 if(!XMode)
 {
  if ((Other.IsA('ShopButton')) && (ShopButton(Other).Owner == Owner))
  {
    if (!bNegMod)
     ShopButton(Other).ItemPrice += ModAmount;
    else
     ShopButton(Other).ItemPrice -= ModAmount;
 Pawn(Owner).ClientMessage("|p7"$ShopButton(Other)$"'s price is now "$ShopButton(Other).ItemPrice$"!");
  }
 }
 if(XMode)
 {
  if ((Other.IsA('EmployeeButton')) && (EmployeeButton(Other).Owner == Owner))
  {
    if (!bNegMod)
     EmployeeButton(Other).PayPerMinute += PayModAmount;
    else
     EmployeeButton(Other).PayPerMinute -= PayModAmount;
 Pawn(Owner).ClientMessage("|p7"$EmployeeButton(Other)$"'s pay per minute is now "$EmployeeButton(Other).PayPerMinute$"!");
  }
 }
 Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     reloadTime=0.000000
     maxRange=8192
     AccurateRange=4096
     BaseAccuracy=0.000000
     bHasMuzzleFlash=True
     bHandToHand=False
     bFallbackWeapon=True
     mpHitDamage=0
     mpBaseAccuracy=1.000000
     mpAccurateRange=4096
     mpMaxRange=8192
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.PistolFire'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=243
     ItemName="|p7Shop Owner's Gun"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Glock'
     PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
     largeIconWidth=47
     largeIconHeight=44
     Description="If you are reading this than you are obviously not playing with other people..."
     beltDescription="|p7SHOPGUN"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=12.65
     CollisionHeight=0.800000
     HitDamage=0
     ModAmount=5
     PayModAmount=1
}
